/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister64;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Panmixia
implements Serializable,
Cloneable {
    protected double theta;
    protected int sampleSize;
    protected List currentLeaves = new ArrayList(1000);
    protected DefaultNode root;
    protected MersenneTwister64 random = RandomUtil.getMersenneTwister64();
    protected Poisson poisson = RandomUtil.getPoisson();

    public void generateGenealogy() {
        this.initialLeaves();
        try {
            this.neutPhase(0.0);
            this.setRoot();
            this.root.getBranch().setLength(0.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void coalescent(double d, List list) {
        if (list.size() < 2) {
            return;
        }
        int n = list.size();
        int n2 = (int)(this.random.nextDouble() * (double)n);
        int n3 = (int)(this.random.nextDouble() * (double)(n - 1));
        if (n3 >= n2) {
            ++n3;
        }
        DefaultNode defaultNode = (DefaultNode)list.get(n2);
        DefaultNode defaultNode2 = (DefaultNode)list.get(n3);
        DefaultNode defaultNode3 = new DefaultNode();
        defaultNode3.setSize(defaultNode.getSize() + defaultNode2.getSize());
        defaultNode3.setTime(d);
        defaultNode3.addChild(defaultNode);
        defaultNode3.addChild(defaultNode2);
        double d2 = d - defaultNode.getTime();
        defaultNode.getBranch().setLength(d2);
        double d3 = d - defaultNode2.getTime();
        defaultNode2.getBranch().setLength(d3);
        list.set(n2, defaultNode3);
        list.remove(n3);
    }

    protected void initialLeaves() {
        this.currentLeaves.clear();
        for (int i = 0; i < this.sampleSize; ++i) {
            DefaultNode defaultNode = new DefaultNode();
            defaultNode.setNameID(i + 1);
            defaultNode.setName(Integer.toString(i + 1));
            defaultNode.setSize(1);
            defaultNode.setTime(0.0);
            this.currentLeaves.add(defaultNode);
        }
    }

    public void generateMutation() {
        this.generateMutation(this.root, this.theta);
    }

    protected void generateMutation(Node node, double d) {
        Branch branch = node.getBranch();
        double d2 = node.getBranch().getLength();
        int n = this.poisson.nextInt(d2 * d / 2.0);
        branch.setMutation(n);
        int n2 = node.getChildCount();
        for (int i = 0; i < n2; ++i) {
            this.generateMutation(node.getChildAt(i), d);
        }
    }

    public double getBranchLength(int n) {
        double d = this.getBranchLength(this.root, n);
        return d;
    }

    protected double getBranchLength(Node node, int n) {
        double d = 0.0;
        int n2 = node.getChildCount();
        for (int i = 0; i < n2; ++i) {
            d += this.getBranchLength(node.getChildAt(i), n);
        }
        if (node.getSize() == n) {
            d += node.getBranch().getLength();
        }
        return d;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    protected void neutPhase(double d) {
        this.neutPhase(d, Double.MAX_VALUE);
    }

    protected void neutPhase(double d, double d2) {
        double d3;
        double d4;
        int n = this.currentLeaves.size();
        double d5 = d;
        while (n > 1 && !((d5 += (d4 = this.waitTime(d3 = 0.5 * (double)n * (double)(n - 1)))) >= d2)) {
            this.coalescent(d5, this.currentLeaves);
            n = this.currentLeaves.size();
        }
    }

    public void setRandom(MersenneTwister64 mersenneTwister64) {
        this.random = mersenneTwister64;
    }

    protected void setRoot() {
        this.root = (DefaultNode)this.currentLeaves.get(0);
    }

    public void setTheta(double d) {
        this.theta = d;
    }

    public void setSampleSize(int n) {
        this.sampleSize = n;
    }

    protected double waitTime(double d) {
        double d2 = -Math.log(1.0 - this.random.nextDouble()) / d;
        return d2;
    }
}

