/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class Nucleotide
implements Serializable {
    public static final String code = "agctAGCT-.mrwsykMRWSYKvhdbVHDBnN";
    public static final String multiCode = "vhdbVHDBnN";
    public static final char[][] bases = new char[][]{{'a', 'a'}, {'g', 'g'}, {'c', 'c'}, {'t', 't'}, {'a', 'a'}, {'g', 'g'}, {'c', 'c'}, {'t', 't'}, {'-', '-'}, {'.', '.'}, {'a', 'c'}, {'a', 'g'}, {'a', 't'}, {'c', 'g'}, {'c', 't'}, {'g', 't'}, {'c', 'a'}, {'g', 'a'}, {'t', 'a'}, {'g', 'c'}, {'t', 'c'}, {'t', 'g'}};
    public static final String[] multiBases = new String[]{"acg", "act", "agt", "cgt", "acg", "act", "agt", "cgt", "acgt", "acgt"};

    public static char[] unpack(char c) throws IllegalArgumentException {
        if (Nucleotide.isInvalidCharacter(c)) {
            throw new IllegalArgumentException("Invalid nucleotide character: " + c);
        }
        if (multiCode.indexOf(c) != -1) {
            String string = multiBases[multiCode.indexOf(c)];
            char[] cArray = new char[string.length()];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = string.charAt(i);
            }
            return cArray;
        }
        if (code.indexOf(c) != -1) {
            return bases[code.indexOf(c)];
        }
        return null;
    }

    public static char pack(char c, char c2) {
        c = Character.toLowerCase(c);
        c2 = Character.toLowerCase(c2);
        for (int i = 0; i < bases.length; ++i) {
            if (c != bases[i][0] || c2 != bases[i][1]) continue;
            return code.charAt(i);
        }
        return 'n';
    }

    public static char pack(char c, char c2, char c3) {
        c = Character.toLowerCase(c);
        c2 = Character.toLowerCase(c2);
        c3 = Character.toLowerCase(c3);
        for (int i = 0; i < multiBases.length; ++i) {
            String string = multiBases[i];
            if (string.indexOf(c) == -1 || string.indexOf(c2) == -1 || string.indexOf(c3) == -1) continue;
            return multiCode.charAt(i);
        }
        return 'n';
    }

    public static boolean isAmbiguous(char c) {
        return code.indexOf(c) > 10;
    }

    public static boolean isValidCharacter(char c) {
        return code.indexOf(c) != -1;
    }

    public static boolean isInvalidCharacter(char c) {
        return code.indexOf(c) == -1;
    }
}

