/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class Haplotype
extends Nucleotide
implements Cloneable,
Serializable {
    public String locus = "locus1";
    public String name = "seq" + Integer.toString(++indexCount);
    public String seq;
    public int count = 1;
    protected static int indexCount = 0;
    protected static final int DEFAULT_COUNT = 1;
    protected static final String DEFAULT_NAME_OF_LOCUS = "locus1";

    public Haplotype() {
        this.setSeq("");
    }

    public Haplotype(String string) {
        this();
        this.setSeq(string);
    }

    public Haplotype(String string, String string2) {
        this();
        this.setName(string2);
        this.setSeq(string);
    }

    public void appendSeq(String string) {
        string = Haplotype.filter(string);
        this.insert(this.length(), string);
    }

    public void insert(int n, String string) {
        String string2 = this.seq.substring(0, n + 1) + string + this.seq.substring(n + 1);
        this.setSeq(string2);
    }

    public void delNucleotide(int n) {
        this.delete(n, n + 1);
    }

    public void delete(int n, int n2) {
        String string = this.seq.substring(0, n) + this.seq.substring(n2);
        this.setSeq(string);
    }

    public int length() {
        return this.seq.length();
    }

    public boolean equals(Object object) {
        if (object instanceof Haplotype) {
            return this.getSeq().equals(((Haplotype)object).getSeq());
        }
        return false;
    }

    public String getSeq() {
        return this.seq;
    }

    public int getLength() {
        return this.getSeq().length();
    }

    public String getName() {
        return this.name;
    }

    public String getNameOfLocus() {
        return this.locus;
    }

    public char getNucleotide(int n) {
        return this.seq.charAt(n);
    }

    public int hashCode() {
        return this.getSeq().hashCode();
    }

    public void insertNucleotide(int n, char c) {
        char[] cArray = new char[]{c};
        String string = new String(cArray);
        this.insert(n, string);
    }

    public void setCount(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.count = n;
    }

    public void setName(String string) {
        this.name = string.trim();
    }

    public void setNameOfLocus(String string) {
        this.locus = string.trim();
    }

    public void setNucleotide(int n, char c) {
        String string = this.seq.substring(0, n) + c + this.seq.substring(n + 1);
        this.setSeq(string);
    }

    public void setSeq(String string) {
        this.seq = string = Haplotype.filter(string);
    }

    public Object clone() {
        Haplotype haplotype = new Haplotype(this.getSeq(), this.name);
        haplotype.setNameOfLocus(this.locus);
        haplotype.setCount(this.count);
        return haplotype;
    }

    public String reverseSeq() {
        String string = "";
        String string2 = this.getSeq();
        for (int i = string2.length() - 1; i >= 0; --i) {
            string = string + string2.charAt(i);
        }
        return string;
    }

    public String reverseComplement() {
        String string = "";
        String string2 = this.getSeq();
        for (int i = string2.length() - 1; i >= 0; --i) {
            int n = "agctAGCTnNmrwsykMRWSYK-".indexOf(string2.charAt(i));
            string = string + "tcgaACGAnNMRWSYKmrwsyk-".charAt(n);
        }
        return string;
    }

    public int getCount() {
        return this.count;
    }

    public static Haplotype parseSeq(String string) {
        Haplotype haplotype = null;
        if ((string = Haplotype.filter(string)).length() > 0) {
            haplotype = new Haplotype(string);
            haplotype.setNameOfLocus(DEFAULT_NAME_OF_LOCUS);
            haplotype.setName("seq" + Integer.toString(indexCount));
            haplotype.setCount(1);
        } else {
            haplotype = null;
        }
        return haplotype;
    }

    public static String filter(String string) {
        for (int i = 0; i <= string.length() - 1; ++i) {
            if ("agctAGCT-.mrwsykMRWSYKvhdbVHDBnN".indexOf(string.charAt(i)) != -1) continue;
            string = i != string.length() - 1 ? string.substring(0, i) + string.substring(i + 1) : string.substring(0, i);
            --i;
        }
        return string;
    }

    public String toString() {
        String string = this.getName();
        string = string + " " + this.getCount();
        string = string + " " + this.getNameOfLocus();
        string = string + " " + this.getSeq();
        return string;
    }

    public void replaceNucleotide(int n, char c) {
        String string = this.getSeq();
        string = string.substring(0, n) + c + string.substring(n + 1);
        this.setSeq(string);
    }
}

