/*
 * Decompiled with CFR 0.152.
 */
public class Factorial {
    public static int intValue(int n) throws IllegalArgumentException {
        if (n < 0 || n > 12) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 1;
        }
        int n2 = 1;
        while (n > 1) {
            n2 *= n;
            --n;
        }
        if (n2 == Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return n2;
    }

    public static long longValue(int n) throws IllegalArgumentException {
        if (n < 0 || n > 20) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 1L;
        }
        long l = 1L;
        while (n > 1) {
            l *= (long)n;
            --n;
        }
        if (l == Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    public static double doubleValue(int n) throws IllegalArgumentException {
        if (n < 0 || n > 142) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return 1.0;
        }
        double d = 1.0;
        while (n > 1) {
            d *= (double)n;
            --n;
        }
        if (d == 9.223372036854776E18) {
            throw new IllegalArgumentException();
        }
        return d;
    }

    public static double stirling(int n) throws IllegalArgumentException {
        if (n == 0) {
            return 1.0;
        }
        double d = Math.sqrt(Math.PI * 2) * Math.pow(n, (double)n + 0.5) * Math.exp(-n);
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Double value reaches the infinite.");
        }
        return d;
    }

    public static double stirlingLog(long l) {
        if (l == 0L) {
            return 0.0;
        }
        double d = ((double)l + 0.5) * Math.log(l) - (double)l + 0.5 * Math.log(Math.PI * 2);
        return d;
    }

    public static double gosper(int n) throws IllegalArgumentException {
        if (n == 0) {
            return 1.0;
        }
        double d = Math.sqrt((2.0 * (double)n + 0.3333333333333333) * Math.PI) * Math.pow(n, n) * Math.exp(-n);
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Double value reaches the infinite.");
        }
        return d;
    }

    public static double gosperLog(long l) {
        if (l == 0L) {
            return 0.0;
        }
        double d = 0.5 * Math.log((2.0 * (double)l + 0.3333333333333333) * Math.PI) + (double)l * Math.log(l) - (double)l;
        return d;
    }

    public static void main(String[] stringArray) {
        System.out.println(Math.pow(2.0, 31.0));
        System.out.println(Integer.MAX_VALUE);
        System.out.println();
        for (int i = 0; i < 20; ++i) {
            System.out.println("i = " + i);
            System.out.println(Factorial.longValue(i));
            System.out.println(Math.exp(Factorial.stirlingLog(i)));
            System.out.println(Math.exp(Factorial.gosperLog(i)));
            System.out.println(Factorial.gosperLog(i));
            System.out.println(Math.log(Factorial.longValue(i)));
            System.out.println();
        }
        System.out.println(Long.MAX_VALUE);
        System.out.println(Factorial.gosperLog(Long.MAX_VALUE));
    }
}

