/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.engine.MersenneTwister64;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuTest {
    public static final int maxSampleSize = 10000;
    public static final int SEQUENCE_PHYLIP = 1;
    public static final int SEQUENCE_MEGA = 2;
    public static final int SEQUENCE_ARLEQUIN = 3;
    public static final int SEQUENCE_NEXUS = 4;
    protected int dataType = -1;
    public static final int X_SIZE = -2;
    protected String directory = "";
    protected String tableFileName = "";
    protected Properties properties;
    protected int n = 10;
    protected static double maxX_percentage = 0.1;
    protected int numOfIterations = 100000;
    protected String[] sequences;
    protected String[] names;
    protected Node userDefinedTreeRoot = null;
    protected Panmixia coalescent = new Panmixia();
    protected GenealogyAnalyzer ga = new GenealogyAnalyzer();
    protected StringBuffer[] sbs = new StringBuffer[10000];
    protected boolean preTableReady = false;
    protected boolean[] preTableReady_VarL_majors;
    protected boolean[] preTableReady_VarL_minors;
    protected boolean[] preTableReady_ExpL_majors;
    protected boolean[] preTableReady_ExpL_minors;
    protected double[] preStoredVarL_majors;
    protected double[] preStoredVarL_minors;
    protected double[] preStoredExpL_majors;
    protected double[] preStoredExpL_minors;
    protected MersenneTwister64 random;
    protected double[] logFactorial = new double[10000];
    protected boolean outgroupAvailable = false;
    protected String outgroupKeyword = "outgroup";
    protected boolean ignoreIndels = true;

    public DuTest() {
        int n;
        for (n = 0; n < this.logFactorial.length; ++n) {
            this.logFactorial[n] = n <= 140 ? Math.log(Factorial.doubleValue(n)) : Factorial.gosperLog(n);
        }
        this.random = new MersenneTwister64(Calendar.getInstance().getTime());
        n = this.maxX(10000);
        this.preTableReady_VarL_majors = new boolean[n];
        this.preTableReady_VarL_minors = new boolean[n];
        this.preTableReady_ExpL_majors = new boolean[n];
        this.preTableReady_ExpL_minors = new boolean[n];
        this.preStoredVarL_majors = new double[n];
        this.preStoredVarL_minors = new double[n];
        this.preStoredExpL_majors = new double[n];
        this.preStoredExpL_minors = new double[n];
    }

    protected double an(int n) {
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d += 1.0 / (double)i;
        }
        return d;
    }

    protected double a2(int n) {
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            d += 1.0 / ((double)i * (double)i);
        }
        return d;
    }

    public void clear() {
        int n = this.maxX(10000);
        this.preTableReady_VarL_majors = new boolean[n];
        this.preTableReady_VarL_minors = new boolean[n];
        this.preTableReady_ExpL_majors = new boolean[n];
        this.preTableReady_ExpL_minors = new boolean[n];
    }

    public double calculateCovTheta_minor_major(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_minor(n, n2);
        double d4 = this.getExpL_major(n, n2);
        double d5 = this.calculateExpected_Lmajor_Lminor(n, n2);
        double d6 = d2 * (d5 / (d4 * d3) - 1.0);
        return d6;
    }

    public double calculateVarTheta_major(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_major(n, n2);
        double d4 = this.getVarL_major(n, n2);
        double d5 = d3 * d / 2.0 + d4 * d2 / 4.0;
        double d6 = 4.0 * d5 / (d3 * d3);
        return d6;
    }

    public double calculateVarTheta_minor(int n, int n2, double d, double d2) {
        double d3 = this.getExpL_minor(n, n2);
        double d4 = this.getVarL_minor(n, n2);
        double d5 = d3 * d / 2.0 + d4 * d2 / 4.0;
        double d6 = 4.0 * d5 / (d3 * d3);
        return d6;
    }

    public double calculateExpected_Lmajor_Lminor(int n, int n2) {
        double d = this.getExpL_major(n, n2);
        double d2 = this.getExpL_minor(n, n2);
        double d3 = this.getVarL_major(n, n2);
        double d4 = this.getVarL_minor(n, n2);
        double d5 = 0.0;
        for (double d6 = 2.0; d6 <= (double)n; d6 += 1.0) {
            d5 += 2.0 / ((d6 - 1.0) * (d6 - 1.0));
        }
        d5 = d5 - (d3 + d4) / 2.0 + d * d2;
        return d5;
    }

    protected double logFactorial(int n) {
        return this.logFactorial[n];
    }

    public double getExpL_major(int n, int n2) {
        return this.preStoredExpL_majors[n2 - 1];
    }

    public double getExpL_minor(int n, int n2) {
        return this.preStoredExpL_minors[n2 - 1];
    }

    public double getVarL_major(int n, int n2) {
        return this.preStoredVarL_majors[n2 - 1];
    }

    public double getVarL_minor(int n, int n2) {
        return this.preStoredVarL_minors[n2 - 1];
    }

    protected double get_ai(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        int n4 = n - n2;
        for (int i = 2; i <= n4; ++i) {
            if (nArray[i] > n3 || n3 >= nArray[i + 1]) continue;
            d = i;
            break;
        }
        if (d != this.get_ai_QuickVer(n, n2, nArray, n3)) {
            System.out.println("Error!!! ai != get_ai_QuickVer(n, x, es, i)!! Exit...");
            System.exit(0);
        }
        return d;
    }

    protected double get_ai_QuickVer(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        int n4 = 2;
        int n5 = n - n2 + 1;
        return this.get_ai_QuickVer(nArray, n3, n4, n5);
    }

    protected double get_ai_QuickVer(int[] nArray, int n, int n2, int n3) {
        if (n2 == n3 - 1) {
            return n2;
        }
        int n4 = (n2 + n3) / 2;
        if (n < nArray[n4]) {
            return this.get_ai_QuickVer(nArray, n, n2, n4);
        }
        return this.get_ai_QuickVer(nArray, n, n4, n3);
    }

    protected double get_bi(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        if (2 <= n3 && n3 < nArray[2]) {
            d = n3;
        } else {
            int n4 = n - n2;
            for (int i = 2; i <= n4; ++i) {
                if (nArray[i] > n3 || n3 >= nArray[i + 1]) continue;
                d = n3 - i;
                break;
            }
        }
        if (d != this.get_bi_QuickVer(n, n2, nArray, n3)) {
            System.out.println("Error!!! bi != get_bi_QuickVer(n, x, es, i)!! Exit...");
            System.exit(0);
        }
        return d;
    }

    protected double get_bi_QuickVer(int n, int n2, int[] nArray, int n3) {
        double d = Double.NaN;
        if (2 <= n3 && n3 < nArray[2]) {
            d = n3;
        } else {
            int n4 = 2;
            int n5 = n - n2 + 1;
            d = this.get_bi_QuickVer(nArray, n3, n4, n5);
        }
        return d;
    }

    protected double get_bi_QuickVer(int[] nArray, int n, int n2, int n3) {
        if (n2 == n3 - 1) {
            return n - n2;
        }
        int n4 = (n2 + n3) / 2;
        if (n < nArray[n4]) {
            return this.get_bi_QuickVer(nArray, n, n2, n4);
        }
        return this.get_bi_QuickVer(nArray, n, n4, n3);
    }

    protected double[][] buildDistanceMatrix(String[] stringArray) {
        int n;
        int n2 = stringArray.length;
        int n3 = n2 - 1;
        double[][] dArrayArray = new double[n3][];
        for (n = 0; n < n3; ++n) {
            dArrayArray[n] = new double[n + 1];
        }
        for (n = 1; n < n2; ++n) {
            String string = stringArray[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                dArrayArray[n - 1][i] = this.numOfNucDiff(string, string2);
            }
        }
        return dArrayArray;
    }

    protected int[] getMinorIndex(Node node) {
        Node node2 = node.getChildAt(0);
        Node node3 = node.getChildAt(1);
        if (node3.getSize() < node2.getSize()) {
            node2 = node3;
        }
        List list = this.ga.getLeavesOfDescendants(node2);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                Node node4 = (Node)list.get(i);
                nArray[i] = Integer.parseInt(node4.getName()) - 1;
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error in getMinorIndex(Node root)! " + exception.getMessage());
                System.exit(0);
            }
        }
        return nArray;
    }

    protected int[] getMinorIndex(Node node, String[] stringArray) {
        Node node2 = node.getChildAt(0);
        Node node3 = node.getChildAt(1);
        if (node3.getSize() < node2.getSize()) {
            node2 = node3;
        }
        List list = this.ga.getLeavesOfDescendants(node2);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            try {
                int n;
                Node node4 = (Node)list.get(i);
                nArray[i] = n = this.indexOf(stringArray, node4.getName());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error in getMinorIndex(Node root)! " + exception.getMessage());
                System.exit(0);
            }
        }
        return nArray;
    }

    protected void getSequencesNoOutgoup(String[] stringArray, Node node) {
        int n;
        int n2 = stringArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            this.sbs[i] = new StringBuffer(10000);
        }
        this.ga.setGenealogy(node);
        List list = this.ga.getNodes();
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            int n4;
            Node node2 = (Node)list.get(n);
            int n5 = node2.getBranch().getMutation();
            if (n5 <= 0) continue;
            List list2 = this.ga.getLeavesOfDescendants(node2);
            for (n4 = 0; n4 < n2; ++n4) {
                blArray[n4] = false;
            }
            for (n4 = 0; n4 < list2.size(); ++n4) {
                Node node3 = (Node)list2.get(n4);
                int n6 = node3.getNameID() - 1;
                for (int i = 0; i < n5; ++i) {
                    this.sbs[n6].append("1");
                }
                blArray[n6] = true;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (blArray[n4]) continue;
                for (int i = 0; i < n5; ++i) {
                    this.sbs[n4].append("0");
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.sbs[n].toString();
        }
    }

    protected double getP(int n, double d, double d2, int n2) {
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Integer.toString(i + 1);
        }
        String[] stringArray2 = new String[n];
        this.coalescent.setSampleSize(n);
        this.coalescent.setTheta(d);
        double d3 = this.an(n);
        double d4 = this.a2(n);
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < this.numOfIterations; ++i) {
            this.coalescent.generateGenealogy();
            this.coalescent.generateMutation();
            Node node = this.coalescent.getRoot();
            this.ga.setGenealogy(node);
            int n3 = this.ga.getNumOfMutations();
            if (n3 < 3) continue;
            this.getSequencesNoOutgoup(stringArray2, node);
            double[][] dArray = this.buildDistanceMatrix(stringArray2);
            Genealogy genealogy = Upgma.tree(dArray, stringArray);
            TreeUtility.rootAtMidPoint(genealogy);
            Node node2 = genealogy.getRoot();
            int n4 = this.getX(node2);
            if (n4 <= n2) {
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                int[] nArray = this.getMinorIndex(node2);
                int n5 = this.getK_minor(stringArray2, nArray);
                int n6 = n3 - n5;
                double d12 = (double)n3 / d3;
                double d13 = 2.0 * (double)n5 / this.getExpL_minor(n, n4);
                double d14 = 2.0 * (double)n6 / this.getExpL_major(n, n4);
                double d15 = (d14 - d13) / (d11 = Math.pow((d10 = this.calculateVarTheta_major(n, n4, d12, d9 = (double)(n3 * (n3 - 1)) / (d3 * d3 + d4))) + (d8 = this.calculateVarTheta_minor(n, n4, d12, d9)) - 2.0 * (d7 = this.calculateCovTheta_minor_major(n, n4, d12, d9)), 0.5));
                if (d15 <= d2) {
                    d6 += 1.0;
                }
            }
            d5 += 1.0;
        }
        double d16 = d6 / d5;
        return d16;
    }

    protected int getK_minor(String[] stringArray, int[] nArray) {
        int n = 0;
        int n2 = stringArray[0].length();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            if (!this.isSegregating(stringArray, i) || (bl = this.isSegregatingInSubgroup(stringArray, i, nArray, false))) continue;
            ++n;
        }
        return n;
    }

    public int getK(String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        int n3 = stringArray[0].length();
        if (this.ignoreIndels) {
            for (int i = 0; i < n3; ++i) {
                if (this.isIndel(stringArray, i) || !this.isSegregating(stringArray, i)) continue;
                ++n;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!this.isSegregating(stringArray, i)) continue;
                ++n;
            }
        }
        return n;
    }

    public int[] getUnfoldedCompactSiteFreqSpectrum(String[] stringArray, String string) {
        int[] nArray = new int[3];
        int n = stringArray[0].length();
        for (int i = 0; i < n; ++i) {
            if (this.ignoreIndels && this.isIndel(stringArray, i) || !this.isSegregating(stringArray, i)) continue;
            int n2 = this.getFreqOfMutAllele(stringArray, string, i);
            if (n2 == 1) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (n2 == 2) {
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (n2 < 3) continue;
            nArray[2] = nArray[2] + 1;
        }
        return nArray;
    }

    public int[] getFoldedCompactSiteFreqSpectrum(String[] stringArray) {
        int[] nArray = new int[3];
        int n = stringArray[0].length();
        for (int i = 0; i < n; ++i) {
            if (this.ignoreIndels && this.isIndel(stringArray, i) || !this.isSegregating(stringArray, i)) continue;
            int n2 = this.getFreqOfMinorAllele(stringArray, i);
            if (n2 == 1) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (n2 == 2) {
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (n2 < 3) continue;
            nArray[2] = nArray[2] + 1;
        }
        return nArray;
    }

    public int getFreqOfMutAllele(String[] stringArray, String string, int n) {
        char c = Character.toLowerCase(string.charAt(n));
        int n2 = stringArray.length;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray[i];
            if (Character.toLowerCase(string2.charAt(n)) == c) continue;
            ++n3;
        }
        return n3;
    }

    public int getFreqOfMinorAllele(String[] stringArray, int n) {
        String string = stringArray[0];
        char c = Character.toLowerCase(string.charAt(n));
        int n2 = stringArray.length;
        int n3 = 0;
        for (int i = 1; i < n2; ++i) {
            String string2 = stringArray[i];
            if (Character.toLowerCase(string2.charAt(n)) == c) continue;
            ++n3;
        }
        n3 = n3 > n2 / 2 ? n2 - n3 : n3;
        return n3;
    }

    protected int getX(Node node) {
        int n = node.getChildAt(0).getSize();
        n = n > this.n / 2 ? this.n - n : n;
        return n;
    }

    protected int getNumOfInterMuts(int n) {
        int n2 = 20;
        if (n > 40) {
            n2 = n;
        }
        return n2;
    }

    protected void buildDistanceMatrix_noOutgroup(double[][] dArray, Node node) {
        this.ga.setGenealogy(node);
        ArrayList arrayList = new ArrayList(this.ga.getNodes());
        boolean[] blArray = new boolean[this.n];
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Node node2 = (Node)arrayList.get(i);
            double d = node2.getBranch().getMutation();
            if (!(d > 0.0)) continue;
            List list = this.ga.getLeavesOfDescendants(node2);
            for (n3 = 0; n3 < this.n; ++n3) {
                blArray[n3] = false;
            }
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Node node3 = (Node)list.get(n2);
                blArray[node3.getNameID() - 1] = true;
            }
            for (n2 = 0; n2 < this.n; ++n2) {
                boolean bl = blArray[n2];
                for (int j = n2 + 1; j < this.n; ++j) {
                    if (bl == blArray[j]) continue;
                    double[] dArray2 = dArray[j - 1];
                    int n4 = n2;
                    dArray2[n4] = dArray2[n4] + d;
                }
            }
        }
    }

    protected void buildDistanceMatrix_WithOutgroup(double[][] dArray, Node node, int n) {
        Object object;
        int n2;
        this.ga.setGenealogy(node);
        ArrayList arrayList = new ArrayList(this.ga.getNodes());
        boolean[] blArray = new boolean[this.n];
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            int n5;
            object = (Node)arrayList.get(n2);
            double d = object.getBranch().getMutation();
            if (!(d > 0.0)) continue;
            List list = this.ga.getLeavesOfDescendants((Node)object);
            for (n5 = 0; n5 < this.n; ++n5) {
                blArray[n5] = false;
            }
            n5 = list.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Node node2 = (Node)list.get(n4);
                blArray[node2.getNameID() - 1] = true;
            }
            for (n4 = 0; n4 < this.n; ++n4) {
                boolean bl = blArray[n4];
                for (int i = n4 + 1; i < this.n; ++i) {
                    if (bl == blArray[i]) continue;
                    double[] dArray2 = dArray[i - 1];
                    int n6 = n4;
                    dArray2[n6] = dArray2[n6] + d;
                }
            }
        }
        n2 = this.getNumOfInterMuts(n);
        this.ga.setGenealogy(node, true);
        object = this.ga.getLeaves();
        for (int i = 0; i < this.n; ++i) {
            Node node3 = (Node)object.get(i);
            double d = 0.0;
            Node node4 = node3;
            do {
                Branch branch = node4.getBranch();
                d += (double)branch.getMutation();
            } while ((node4 = node4.getParent()) != node);
            dArray[this.n - 1][node3.getNameID() - 1] = d + (double)n2;
        }
    }

    protected void getSequences_noOutgroup(String[] stringArray, Node node) {
        int n;
        this.ga.setGenealogy(node);
        boolean[] blArray = new boolean[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.sbs[i] = new StringBuffer(10000);
        }
        List list = this.ga.getNodes();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            Node node2 = (Node)list.get(n);
            int n4 = node2.getBranch().getMutation();
            if (n4 <= 0) continue;
            List list2 = this.ga.getLeavesOfDescendants(node2);
            for (n3 = 0; n3 < this.n; ++n3) {
                blArray[n3] = false;
            }
            for (n3 = 0; n3 < list2.size(); ++n3) {
                Node node3 = (Node)list2.get(n3);
                int n5 = node3.getNameID() - 1;
                for (int i = 0; i < n4; ++i) {
                    this.sbs[n5].append("1");
                }
                blArray[n5] = true;
            }
            for (n3 = 0; n3 < this.n; ++n3) {
                if (blArray[n3]) continue;
                for (int i = 0; i < n4; ++i) {
                    this.sbs[n3].append("0");
                }
            }
        }
        for (n = 0; n < this.n; ++n) {
            stringArray[n] = this.sbs[n].toString();
        }
    }

    protected void getBranchsWithSize_Folded(Node node, List<Node> list, int n) {
        int n2 = node.getChildCount();
        int n3 = node.getSize();
        if (n3 == n || n3 == this.n - n) {
            list.add(node);
        } else if (2 < n3 && n3 < this.n - 2 && n == -2) {
            list.add(node);
        }
        for (int i = 0; i < n2; ++i) {
            this.getBranchsWithSize_Folded(node.getChildAt(i), list, n);
        }
    }

    protected String getP_noOutgroup(double d, int[] nArray) {
        String[] stringArray = new String[this.n];
        for (int i = 0; i < this.n; ++i) {
            stringArray[i] = Integer.toString(i + 1);
        }
        String[] stringArray2 = new String[this.n];
        int n = this.maxX(this.n);
        double[] dArray = new double[this.numOfIterations];
        int n2 = 0;
        int n3 = this.sum(nArray);
        double d2 = this.an(this.n);
        double d3 = this.a2(this.n);
        double d4 = (double)n3 / d2;
        ArrayList<Node> arrayList = new ArrayList<Node>(2 * this.n);
        this.coalescent.setSampleSize(this.n);
        for (int i = 0; i < this.numOfIterations; ++i) {
            this.coalescent.generateGenealogy();
            Node node = this.coalescent.getRoot();
            this.ga.setGenealogy(node);
            if (nArray[0] > 0) {
                arrayList.clear();
                this.getBranchsWithSize_Folded(node, arrayList, 1);
                this.assignMutations(arrayList, nArray[0]);
            }
            if (nArray[1] > 0) {
                arrayList.clear();
                this.getBranchsWithSize_Folded(node, arrayList, 2);
                this.assignMutations(arrayList, nArray[1]);
            }
            if (nArray[2] > 0) {
                arrayList.clear();
                this.getBranchsWithSize_Folded(node, arrayList, -2);
                this.assignMutations(arrayList, nArray[2]);
            }
            int n4 = this.ga.getNumOfMutations();
            double[][] dArray2 = this.initialDistance(false);
            this.buildDistanceMatrix_noOutgroup(dArray2, node);
            Genealogy genealogy = Upgma.tree(dArray2, stringArray);
            Node node2 = genealogy.getRoot();
            int n5 = this.getX(node2);
            if (n5 > n) continue;
            this.getSequences_noOutgroup(stringArray2, node);
            int[] nArray2 = this.getMinorIndex(node2);
            int n6 = this.getK_minor(stringArray2, nArray2);
            int n7 = n4 - n6;
            double d5 = this.getExpL_major(this.n, n5);
            double d6 = this.getExpL_minor(this.n, n5);
            double d7 = (double)n4 / d2;
            double d8 = 2.0 * (double)n6 / d6;
            double d9 = 2.0 * (double)n7 / d5;
            double d10 = d9 - d8;
            double d11 = (double)(n4 * (n4 - 1)) / (d2 * d2 + d3);
            double d12 = this.calculateVarTheta_major(this.n, n5, d7, d11);
            double d13 = this.calculateVarTheta_minor(this.n, n5, d7, d11);
            double d14 = this.calculateCovTheta_minor_major(this.n, n5, d7, d11);
            double d15 = Math.pow(d12 + d13 - 2.0 * d14, 0.5);
            dArray[n2] = d10 / d15;
            ++n2;
        }
        QSort.sort(dArray, 0, n2 - 1);
        String string = "-1";
        if (d < dArray[0]) {
            string = "P = " + Double.toString(1.0 / (double)this.numOfIterations);
        } else if (dArray[n2 - 1] <= d) {
            string = "P > " + Double.toString((double)n2 / (double)this.numOfIterations);
        } else {
            for (int i = 0; i < n2 - 1; ++i) {
                if (!(dArray[i] <= d) || !(d < dArray[i + 1])) continue;
                string = "P = " + Double.toString((double)(i + 1) / (double)this.numOfIterations);
                break;
            }
        }
        return string;
    }

    public int sum(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            n += nArray[i];
        }
        return n;
    }

    protected void assignMutations(List<Node> list, int n) {
        double d;
        int n2;
        int n3 = list.size();
        double[] dArray = new double[n3];
        double d2 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = d = list.get(n2).getBranch().getLength();
            d2 += d;
        }
        dArray[0] = dArray[0] / d2;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n2] = dArray[n2] / d2 + dArray[n2 - 1];
        }
        for (n2 = 0; n2 < n; ++n2) {
            d = this.random.nextDouble();
            int n4 = this.getMutNodeIndex(dArray, d);
            Branch branch = list.get(n4).getBranch();
            int n5 = branch.getMutation();
            branch.setMutation(n5 + 1);
        }
    }

    protected int getMutNodeIndex(double[] dArray, double d) {
        return this.getMutNodeIndex(dArray, d, 0, dArray.length - 1);
    }

    protected int getMutNodeIndex(double[] dArray, double d, int n, int n2) {
        if (n < n2) {
            int n3 = (n + n2) / 2;
            double d2 = dArray[n3];
            if (d <= d2) {
                return this.getMutNodeIndex(dArray, d, n, n3);
            }
            if (n3 == n) {
                return n2;
            }
            return this.getMutNodeIndex(dArray, d, n3, n2);
        }
        return n2;
    }

    protected String getP_WithOutgroup(double d, int[] nArray) {
        String[] stringArray = new String[this.n + 1];
        for (int i = 0; i < this.n; ++i) {
            stringArray[i] = Integer.toString(i + 1);
        }
        stringArray[this.n] = this.outgroupKeyword;
        String[] stringArray2 = new String[this.n];
        int n = this.maxX(this.n);
        double[] dArray = new double[this.numOfIterations];
        int n2 = 0;
        int n3 = this.sum(nArray);
        double d2 = this.an(this.n);
        double d3 = this.a2(this.n);
        this.coalescent.setSampleSize(this.n);
        for (int i = 0; i < this.numOfIterations; ++i) {
            this.coalescent.generateGenealogy();
            Node node = this.coalescent.getRoot();
            this.ga.setGenealogy(node);
            if (nArray[0] > 0) {
                this.assignMutations(this.ga.getLeaves(), nArray[0]);
            }
            if (nArray[1] > 0) {
                this.assignMutations(this.ga.getBranchsWithSize(2), nArray[1]);
            }
            if (nArray[2] > 0) {
                this.assignMutations(this.ga.getBranchsWithSize(-2), nArray[2]);
            }
            this.ga.setGenealogy(node);
            int n4 = this.ga.getNumOfMutations();
            double[][] dArray2 = this.initialDistance(true);
            this.buildDistanceMatrix_WithOutgroup(dArray2, node, n3);
            Genealogy genealogy = Upgma.tree(dArray2, this.names);
            Node node2 = genealogy.getRoot();
            Node node3 = node2.getChildAt(0);
            Node node4 = node2.getChildAt(1);
            node2 = node3.getSize() == 1 ? node4 : node3;
            int n5 = this.getX(node2);
            if (n5 > n) continue;
            this.getSequences_noOutgroup(stringArray2, node);
            int[] nArray2 = this.getMinorIndex(node2);
            int n6 = this.getK_minor(stringArray2, nArray2);
            int n7 = n4 - n6;
            double d4 = this.getExpL_major(this.n, n5);
            double d5 = this.getExpL_minor(this.n, n5);
            double d6 = (double)n4 / d2;
            double d7 = 2.0 * (double)n6 / d5;
            double d8 = 2.0 * (double)n7 / d4;
            double d9 = d8 - d7;
            double d10 = (double)(n4 * (n4 - 1)) / (d2 * d2 + d3);
            double d11 = this.calculateVarTheta_major(this.n, n5, d6, d10);
            double d12 = this.calculateVarTheta_minor(this.n, n5, d6, d10);
            double d13 = this.calculateCovTheta_minor_major(this.n, n5, d6, d10);
            double d14 = Math.pow(d11 + d12 - 2.0 * d13, 0.5);
            dArray[n2] = d9 / d14;
            ++n2;
        }
        QSort.sort(dArray, 0, n2 - 1);
        String string = "-1";
        if (d < dArray[0]) {
            string = "P = " + Double.toString(1.0 / (double)this.numOfIterations);
        } else if (dArray[n2 - 1] <= d) {
            string = "P > " + Double.toString((double)n2 / (double)this.numOfIterations);
        } else {
            for (int i = 0; i < n2 - 1; ++i) {
                if (!(dArray[i] <= d) || !(d < dArray[i + 1])) continue;
                string = "P = " + Double.toString((double)(i + 1) / (double)this.numOfIterations);
                break;
            }
        }
        return string;
    }

    public boolean isIndel(String[] stringArray, int n) {
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (stringArray[i].charAt(n) != '-') continue;
            return true;
        }
        return false;
    }

    protected boolean isSegregating(String[] stringArray, int n) {
        char c;
        int n2;
        boolean bl = false;
        int n3 = stringArray.length;
        char c2 = '\u0000';
        for (n2 = 0; n2 < n3; ++n2) {
            c = stringArray[n2].charAt(n);
            if (Nucleotide.isAmbiguous(c)) continue;
            c2 = Character.toLowerCase(c);
            break;
        }
        if (c2 != '\u0000') {
            for (n2 = 0; n2 < n3; ++n2) {
                c = Character.toLowerCase(stringArray[n2].charAt(n));
                if (c2 != c) {
                    if (Nucleotide.isAmbiguous(c)) {
                        char[] cArray = Nucleotide.unpack(c);
                        boolean bl2 = false;
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] != c2) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
                if (bl) break;
            }
        }
        return bl;
    }

    protected boolean isSegregatingInSubgroup(String[] stringArray, int n, int[] nArray, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            char c;
            int n2;
            int n3 = nArray.length;
            char c2 = '\u0000';
            for (n2 = 0; n2 < n3; ++n2) {
                c = stringArray[nArray[n2]].charAt(n);
                if (Nucleotide.isAmbiguous(c)) continue;
                c2 = Character.toLowerCase(c);
                break;
            }
            if (c2 != '\u0000') {
                for (n2 = 0; n2 < n3; ++n2) {
                    c = Character.toLowerCase(stringArray[nArray[n2]].charAt(n));
                    if (c2 != c) {
                        if (Nucleotide.isAmbiguous(c)) {
                            char[] cArray = Nucleotide.unpack(c);
                            boolean bl3 = false;
                            for (int i = 0; i < cArray.length; ++i) {
                                if (cArray[i] != c2) continue;
                                bl3 = true;
                                break;
                            }
                            if (!bl3) {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                        }
                    }
                    if (!bl2) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n4 = stringArray.length;
            int n5 = nArray.length;
            int[] nArray2 = new int[n4 - n5];
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                if (this.indexOf(nArray, i) == -1) {
                    nArray2[n6] = i;
                    ++n6;
                }
                ++i;
            }
            bl2 = this.isSegregatingInSubgroup(stringArray, n, nArray2, true);
        }
        return bl2;
    }

    protected int indexOf(int[] nArray, int n) {
        int n2 = -1;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    protected int indexOf(String[] stringArray, String string) {
        int n = -1;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    protected double[][] initialDistance(boolean bl) {
        int n = -1;
        n = bl ? this.n : this.n - 1;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[i + 1];
        }
        return dArrayArray;
    }

    public boolean isThereOutgroup(List<Haplotype> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Haplotype haplotype = list.get(i);
            if (!haplotype.name.equalsIgnoreCase(this.outgroupKeyword)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void loadProperties() {
        this.properties = new Properties();
        try {
            URL uRL = this.getClass().getClassLoader().getResource("properties.txt");
            InputStream inputStream = uRL.openConnection().getInputStream();
            this.properties.load(inputStream);
            inputStream.close();
            this.directory = (String)this.properties.get("directory");
            this.tableFileName = (String)this.properties.get("preCalculatedTable");
            String string = (String)this.properties.get("ignoreIndels");
            this.ignoreIndels = string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true");
            String string2 = (String)this.properties.get("numOfIterations");
            try {
                this.numOfIterations = Integer.parseInt(string2);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.out.println("Error when loading properties.txt! " + exception.getMessage());
            System.out.println("Exit...");
            System.exit(0);
        }
    }

    public int maxX(int n) {
        int n2 = (int)(maxX_percentage * (double)(n - 1) / 2.0);
        n2 = n2 == 0 ? 1 : n2;
        return n2;
    }

    protected int numOfNucDiff(String string, String string2) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            int n3;
            char[] cArray;
            char c;
            char c2 = Character.toLowerCase(string.charAt(i));
            if (c2 == (c = Character.toLowerCase(string2.charAt(i)))) continue;
            if (Nucleotide.isAmbiguous(c2)) {
                cArray = Nucleotide.unpack(c2);
                if (Nucleotide.isAmbiguous(c)) {
                    char[] cArray2 = Nucleotide.unpack(c);
                    n3 = 0;
                    for (int j = 0; j < cArray.length; ++j) {
                        for (int k = 0; k < cArray2.length; ++k) {
                            if (cArray[j] != cArray2[k]) continue;
                            n3 = 1;
                            break;
                        }
                        if (n3 != 0) break;
                    }
                    if (n3 != 0) continue;
                    ++n;
                    continue;
                }
                boolean bl = false;
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    if (cArray[n3] != c) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ++n;
                continue;
            }
            if (Nucleotide.isAmbiguous(c)) {
                cArray = Nucleotide.unpack(c);
                boolean bl = false;
                for (n3 = 0; n3 < cArray.length; ++n3) {
                    if (c2 != cArray[n3]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                ++n;
                continue;
            }
            ++n;
        }
        return n;
    }

    protected void readPreEstablishedTables() {
        this.readPreEstablishedTables(this.n);
    }

    protected void readPreEstablishedTables(int n) {
        this.clear();
        try {
            int n2;
            File file = new File(this.directory);
            File file2 = new File(file, this.tableFileName);
            String string = file2.getAbsolutePath();
            List list = ReadTextFile.readLineToLine(string);
            for (n2 = 0; n2 < list.size(); ++n2) {
                String string2 = (String)list.get(n2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                int n4 = Integer.parseInt(stringTokenizer.nextToken());
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                double d4 = Double.parseDouble(stringTokenizer.nextToken());
                if (n3 != n || n4 - 1 >= this.preStoredExpL_majors.length) continue;
                this.preStoredExpL_majors[n4 - 1] = d;
                this.preStoredExpL_minors[n4 - 1] = d2;
                this.preStoredVarL_majors[n4 - 1] = d3;
                this.preStoredVarL_minors[n4 - 1] = d4;
                this.preTableReady_ExpL_majors[n4 - 1] = true;
                this.preTableReady_ExpL_minors[n4 - 1] = true;
                this.preTableReady_VarL_majors[n4 - 1] = true;
                this.preTableReady_VarL_minors[n4 - 1] = true;
            }
            n2 = this.maxX(n);
            for (int i = 0; i < n2; ++i) {
                if (this.preTableReady_ExpL_majors[i]) continue;
                System.out.println("Error! A pre-established table is needed. Please try this command first: initialTable n.");
                System.out.println("Exit...");
                System.exit(0);
            }
        }
        catch (Exception exception) {
            System.out.println("Error when read the pre-calculated table! " + exception.getMessage());
            System.out.println("Exit...");
            System.exit(0);
        }
    }

    public void setSequences(String[] stringArray, String[] stringArray2) {
        this.sequences = stringArray;
        this.names = stringArray2;
    }

    public void run() {
        int n;
        this.readPreEstablishedTables(this.n);
        String[] stringArray = this.sequences;
        String[] stringArray2 = this.names;
        if (this.outgroupAvailable) {
            stringArray = new String[this.n];
            stringArray2 = new String[this.n];
            for (n = 0; n < this.n; ++n) {
                stringArray[n] = this.sequences[n];
                stringArray2[n] = this.names[n];
            }
        }
        n = this.getK(stringArray);
        double d = this.an(this.n);
        double d2 = this.a2(this.n);
        int n2 = this.maxX(this.n);
        System.out.println("n = " + this.n + "; the number of segregating sites (K) = " + n);
        if (this.outgroupAvailable) {
            Object object;
            Object object2;
            Node node = null;
            String string = null;
            if (this.userDefinedTreeRoot == null) {
                object2 = this.buildDistanceMatrix(this.sequences);
                object = Upgma.tree((double[][])object2, this.names);
                this.rootTree((Genealogy)object, this.outgroupKeyword);
                node = object.getRoot();
                string = TreeCoder.code(node);
            } else {
                node = this.userDefinedTreeRoot;
                string = "User defined tree: " + TreeCoder.code(node);
            }
            object2 = null;
            object = node.getChildAt(0);
            Node node2 = node.getChildAt(1);
            object2 = object.getSize() == 1 ? (Object)node2 : (Object)object;
            int n3 = this.getX((Node)object2);
            int n4 = this.n - n3;
            int n5 = this.n - n2;
            if (n3 <= n2) {
                int[] nArray = this.getMinorIndex((Node)object2, stringArray2);
                int n6 = this.getK_minor(stringArray, nArray);
                int n7 = n - n6;
                double d3 = (double)n / d;
                double d4 = 2.0 * (double)n6 / this.getExpL_minor(this.n, n3);
                double d5 = 2.0 * (double)n7 / this.getExpL_major(this.n, n3);
                double d6 = (double)(n * (n - 1)) / (d * d + d2);
                double d7 = this.calculateVarTheta_major(this.n, n3, d3, d6);
                double d8 = this.calculateVarTheta_minor(this.n, n3, d3, d6);
                double d9 = this.calculateCovTheta_minor_major(this.n, n3, d3, d6);
                double d10 = Math.pow(d7 + d8 - 2.0 * d9, 0.5);
                int[] nArray2 = this.getUnfoldedCompactSiteFreqSpectrum(stringArray, this.sequences[this.sequences.length - 1]);
                double d11 = (d5 - d4) / d10;
                String string2 = this.getP_WithOutgroup(d11, nArray2);
                System.out.println();
                System.out.println(string2);
                System.out.println();
                System.out.println("gamma = " + n4 + " gamma_min = " + n5 + " observed Du = " + d11);
                System.out.println("K_minor = " + n6 + " K_major = " + n7);
                System.out.println("theta_minor = " + d4 + " theta_major = " + d5);
                System.out.println();
                System.out.println(string);
                System.out.println();
            } else {
                System.out.println();
                System.out.println("gamma = " + n4 + " gamma_min = " + n5 + ". gamma < gamma_min");
                System.out.println("It is a balanced tree, so the Du test will not be performed.");
                System.out.println();
                System.out.println(string);
                System.out.println();
            }
        } else {
            Node node = null;
            String string = null;
            if (this.userDefinedTreeRoot == null) {
                double[][] dArray = this.buildDistanceMatrix(stringArray);
                Genealogy genealogy = Upgma.tree(dArray, stringArray2);
                TreeUtility.rootAtMidPoint(genealogy);
                node = genealogy.getRoot();
                string = TreeCoder.code(node);
            } else {
                node = this.userDefinedTreeRoot;
                string = "User defined tree: " + TreeCoder.code(node);
            }
            int n8 = this.getX(node);
            int n9 = this.n - n8;
            int n10 = this.n - n2;
            if (n8 <= n2) {
                int[] nArray = this.getMinorIndex(node, stringArray2);
                int n11 = this.getK_minor(stringArray, nArray);
                int n12 = n - n11;
                double d12 = (double)n / d;
                double d13 = 2.0 * (double)n11 / this.getExpL_minor(this.n, n8);
                double d14 = 2.0 * (double)n12 / this.getExpL_major(this.n, n8);
                double d15 = (double)(n * (n - 1)) / (d * d + d2);
                double d16 = this.calculateVarTheta_major(this.n, n8, d12, d15);
                double d17 = this.calculateVarTheta_minor(this.n, n8, d12, d15);
                double d18 = this.calculateCovTheta_minor_major(this.n, n8, d12, d15);
                double d19 = Math.pow(d16 + d17 - 2.0 * d18, 0.5);
                int[] nArray3 = this.getFoldedCompactSiteFreqSpectrum(stringArray);
                double d20 = (d14 - d13) / d19;
                String string3 = this.getP_noOutgroup(d20, nArray3);
                System.out.println();
                System.out.println(string3);
                System.out.println();
                System.out.println("gamma = " + n9 + " gamma_min = " + n10 + " observed Du = " + d20);
                System.out.println("K_minor = " + n11 + " K_major = " + n12);
                System.out.println("theta_minor = " + d13 + " theta_major = " + d14);
                System.out.println();
                System.out.println(string);
                System.out.println();
            } else {
                System.out.println();
                System.out.println("gamma = " + n9 + " gamma_min = " + n10 + ". gamma < gamma_min");
                System.out.println("It is a balanced tree, so the Du test will not be performed.");
                System.out.println();
                System.out.println(string);
                System.out.println();
            }
        }
    }

    protected void rootTree(Genealogy genealogy, String string) {
        Node node = genealogy.getRoot();
        List list = this.ga.getLeavesOfDescendants(node);
        Node node2 = null;
        for (int i = 0; i < list.size(); ++i) {
            Node node3 = (Node)list.get(i);
            if (!node3.getName().equalsIgnoreCase(string)) continue;
            node2 = node3;
            break;
        }
        TreeUtility.setRootAt(genealogy, node2, node2.getBranch().getLength() / 2.0);
    }

    protected void setUserDefinedTree(Node node) {
        this.userDefinedTreeRoot = node;
    }

    protected List<Haplotype> autoDetectFormat(String string) throws IOException {
        Cloneable cloneable;
        int n;
        Object[] objectArray = new Object[]{new ReadArlequin(), new ReadMega(), new ReadPhylip(), new ReadNexus()};
        List list = null;
        for (n = 0; n < objectArray.length; ++n) {
            try {
                cloneable = (ReadSeqFile)objectArray[n];
                list = cloneable.readSeq(string);
                if (cloneable instanceof ReadArlequin) {
                    this.dataType = 3;
                }
                if (cloneable instanceof ReadMega) {
                    this.dataType = 2;
                }
                if (cloneable instanceof ReadPhylip) {
                    this.dataType = 1;
                }
                if (cloneable instanceof ReadNexus) {
                    this.dataType = 4;
                }
                if (list == null || list.isEmpty()) continue;
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (list == null) {
            throw new IOException("Unsupported data format! The current version only supports four formats: ARLEQUIN, MEGA, PHYLIP and NEXUS!");
        }
        for (n = 0; n < list.size(); ++n) {
            cloneable = (Haplotype)list.get(n);
            if (((Haplotype)cloneable).count != 0) continue;
            list.remove(n);
            --n;
        }
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Haplotype haplotype = (Haplotype)list.get(i);
            if (haplotype.count <= 1) continue;
            for (int j = 0; j < haplotype.count - 1; ++j) {
                Haplotype haplotype2 = new Haplotype(haplotype.getSeq(), haplotype.getName() + "_" + (j + 1));
                haplotype2.setCount(1);
                list.add(haplotype2);
            }
            haplotype.setName(haplotype.getName() + "_0");
            haplotype.setCount(1);
        }
        return list;
    }

    protected void examineAlignedLength(String[] stringArray, String[] stringArray2) {
        int n = stringArray[0].length();
        for (int i = 1; i < stringArray.length; ++i) {
            int n2 = stringArray[i].length();
            if (n == n2) continue;
            System.out.println("It seems the sequences hasn't been aligned. The length of the first sequence (" + stringArray2[0] + ") is " + n + ", but the sequence of " + stringArray2[i] + " is " + n2 + ". They are not equal with each other.");
            System.out.println("Exit...");
            System.exit(0);
        }
    }

    protected void examineTreeAndDataConsistancy(String[] stringArray, Node node) {
        this.ga.setGenealogy(node);
        List list = this.ga.getLeaves();
        int n = list.size();
        int n2 = stringArray.length;
        if (n != n2) {
            System.out.println();
            System.out.println("The number of leaves is " + n + " in the user defined tree.");
            System.out.println("The number of sequences is " + n2);
            System.out.println("They must be equal with each other if the tree was built from the data. But they are not. So exit....");
            System.out.println();
            System.exit(0);
        } else {
            boolean bl = false;
            System.out.println();
            for (int i = 0; i < n; ++i) {
                Node node2 = (Node)list.get(i);
                if (this.indexOf(stringArray, node2.getName()) != -1) continue;
                System.out.println("The lineage " + node2.getName() + " in the tree cannot be found in the data.");
                bl = true;
            }
            if (bl) {
                System.out.println("Exit...");
                System.out.println();
                System.exit(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        block18: {
            DuTest duTest = new DuTest();
            duTest.loadProperties();
            try {
                if (stringArray.length == 1) {
                    try {
                        String string = duTest.directory;
                        String string2 = stringArray[0];
                        File file = new File(string);
                        File file2 = new File(file, string2);
                        String string3 = file2.getAbsolutePath();
                        if (file2.exists()) {
                            Object object;
                            int n;
                            List<Haplotype> list = duTest.autoDetectFormat(string3);
                            int n2 = list.size();
                            boolean bl = duTest.isThereOutgroup(list);
                            if (bl) {
                                --n2;
                            }
                            String[] stringArray2 = new String[list.size()];
                            String[] stringArray3 = new String[list.size()];
                            for (n = 0; n < list.size(); ++n) {
                                object = list.get(n);
                                stringArray2[n] = ((Haplotype)object).seq;
                                stringArray3[n] = ((Haplotype)object).name;
                            }
                            for (n = 0; n < list.size() - 1; ++n) {
                                if (!stringArray3[n].equalsIgnoreCase(duTest.outgroupKeyword)) continue;
                                object = stringArray3[list.size() - 1];
                                stringArray3[list.size() - 1] = stringArray3[n];
                                stringArray3[n] = object;
                                object = stringArray2[list.size() - 1];
                                stringArray2[list.size() - 1] = stringArray2[n];
                                stringArray2[n] = object;
                            }
                            duTest.examineAlignedLength(stringArray2, stringArray3);
                            duTest.n = n2;
                            duTest.setSequences(stringArray2, stringArray3);
                            duTest.outgroupAvailable = bl;
                            duTest.run();
                            System.out.println("Finished...");
                            break block18;
                        }
                        System.out.println("Error! The file doesn't exist: " + string3);
                        System.out.println("Exit...");
                    }
                    catch (IOException iOException) {
                        System.out.println("Error! " + iOException.getMessage());
                        System.out.println("Exit...");
                    }
                    break block18;
                }
                if (stringArray.length == 2) {
                    try {
                        String string = duTest.directory;
                        String string4 = stringArray[0];
                        File file = new File(string);
                        File file3 = new File(file, string4);
                        String string5 = file3.getAbsolutePath();
                        if (file3.exists()) {
                            Object object;
                            int n;
                            List<Haplotype> list = duTest.autoDetectFormat(string5);
                            int n3 = list.size();
                            boolean bl = duTest.isThereOutgroup(list);
                            if (bl) {
                                --n3;
                            }
                            String[] stringArray4 = new String[list.size()];
                            String[] stringArray5 = new String[list.size()];
                            for (n = 0; n < list.size(); ++n) {
                                object = list.get(n);
                                stringArray4[n] = ((Haplotype)object).seq;
                                stringArray5[n] = ((Haplotype)object).name;
                            }
                            for (n = 0; n < list.size() - 1; ++n) {
                                if (!stringArray5[n].equalsIgnoreCase(duTest.outgroupKeyword)) continue;
                                object = stringArray5[list.size() - 1];
                                stringArray5[list.size() - 1] = stringArray5[n];
                                stringArray5[n] = object;
                                object = stringArray4[list.size() - 1];
                                stringArray4[list.size() - 1] = stringArray4[n];
                                stringArray4[n] = object;
                            }
                            String string6 = stringArray[1];
                            file3 = new File(file, string6);
                            object = file3.getAbsolutePath();
                            if (file3.exists()) {
                                List list2 = ReadTextFile.readLineToLine((String)object);
                                String string7 = (String)list2.get(0);
                                Node node = TreeDecoder.decode(string7);
                                duTest.ga.setGenealogy(node, true);
                                duTest.examineAlignedLength(stringArray4, stringArray5);
                                duTest.examineTreeAndDataConsistancy(stringArray5, node);
                                duTest.n = n3;
                                duTest.setSequences(stringArray4, stringArray5);
                                duTest.outgroupAvailable = bl;
                                duTest.setUserDefinedTree(node);
                                duTest.run();
                                System.out.println("Finished...");
                            } else {
                                System.out.println("Error! The file doesn't exist: " + (String)object);
                                System.out.println("Exit...");
                            }
                            break block18;
                        }
                        System.out.println("Error! The file doesn't exist: " + string5);
                        System.out.println("Exit...");
                    }
                    catch (IOException iOException) {
                        System.out.println("Error! " + iOException.getMessage());
                        System.out.println("Exit...");
                    }
                    break block18;
                }
                System.out.println();
                System.out.println("How to use it:");
                System.out.println("./duTest inputFile");
                System.out.println("./duTest inputFile treeFile");
                System.out.println();
            }
            catch (Exception exception) {
                System.out.println("Error! " + exception.getMessage());
                exception.printStackTrace();
                System.out.println("Exit...");
            }
        }
    }
}

