/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultTree
implements Tree,
Serializable {
    protected Node treeRoot;
    protected boolean needUpdateSize = true;
    protected static final double[] doubleZero = new double[0];
    protected static final int[] intZero = new int[0];
    protected Node[] allNodes;
    protected List nodesList;
    protected boolean needSorting = true;
    ChangeEvent event = new ChangeEvent("tree changed");
    transient ArrayList listener;
    int ncount = 0;
    StringBuffer treeString = new StringBuffer();
    public static Comparator nodeSorter = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = ((Node)object).getSize() - ((Node)object2).getSize();
            if (n < 0) {
                return -1;
            }
            if (n == 0) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object object) {
            return nodeSorter == (Comparable)object;
        }
    };
    ArrayList blist = new ArrayList();
    int sampleSize = 0;
    int nodeSize = 0;

    public DefaultTree() {
    }

    public DefaultTree(Node node) {
        this();
        this.setRoot(node);
    }

    void markTree(int n) {
        if (this.allNodes == null && this.nodesList == null) {
            TreeUtility.markSubtree(n, this.getRoot());
            return;
        }
        if (this.allNodes != null) {
            int n2 = this.allNodes.length;
            for (int i = 0; i < n2; ++i) {
                if (this.allNodes[i] == null) continue;
                this.allNodes[i].setMark(n);
            }
            return;
        }
        if (this.nodesList != null) {
            for (Node node : this.nodesList) {
                if (node == null) continue;
                node.setMark(n);
            }
            return;
        }
    }

    public Node getRoot() {
        return this.treeRoot;
    }

    public void setRoot(Node node) {
        this.treeRoot = node;
        this.needUpdateSize = true;
        this.allNodes = null;
        this.nodesList = null;
        this.needSorting = true;
        this.fireChangeEvent();
        this.updateSize();
    }

    public void setRoot(Node node, Node[] nodeArray) {
        this.setRoot(node);
        this.allNodes = nodeArray;
    }

    public void setRoot(Node node, List list) {
        this.setRoot(node);
        this.allNodes = list.toArray(new Node[list.size()]);
    }

    public void setUpdateSize(boolean bl) {
        this.needUpdateSize = bl;
    }

    public void clear() {
        this.setRoot(null);
    }

    protected void fireChangeEvent() {
        if (this.listener == null) {
            return;
        }
        for (ChangeListener changeListener : this.listener) {
            changeListener.stateChanged(this.event);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener == null) {
            this.listener = new ArrayList();
        }
        this.listener.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.listener == null) {
            return;
        }
        this.listener.remove(changeListener);
    }

    public int leafCount() {
        return this.updateSize();
    }

    public int nodeCount() {
        this.updateSize();
        return this.ncount;
    }

    protected int updateSize() {
        if (this.needUpdateSize) {
            this.ncount = 0;
            this.sizeCount(this.getRoot());
            this.setUpdateSize(false);
        }
        return this.getRoot().getSize();
    }

    void sizeCount(Node node) {
        ++this.ncount;
        if (node.getChildCount() == 0) {
            node.setSize(1);
            return;
        }
        int n = 0;
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.sizeCount(node.getChildAt(i));
            n += node.getChildAt(i).getSize();
        }
        node.setSize(n);
    }

    public String toString() {
        this.treeString.delete(0, this.treeString.length());
        this.treeString.append("\nThe Tree has " + this.size() + " nodes and " + this.leafSize() + " leafs :\n");
        this.markTree(0);
        this.print(this.getRoot());
        return this.treeString.toString();
    }

    void print(Node node) {
        if (node.getMark() != 0) {
            return;
        }
        this.treeString.append(node);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.print(node.getChildAt(i));
        }
        node.setMark(1);
    }

    public Node[] getNodes() {
        if (this.allNodes != null) {
            if (this.needSorting) {
                Arrays.sort(this.allNodes, nodeSorter);
            }
            this.needSorting = false;
            return this.allNodes;
        }
        return null;
    }

    public List getAllNodes() {
        return this.getNodes(-1);
    }

    public List getNodes(int n) {
        this.blist.clear();
        this.updateSize();
        this.markTree(0);
        this.NodeOfSize(this.getRoot(), n);
        return this.blist;
    }

    public void NodeOfSize(Node node, int n) {
        if (node.getMark() != 0) {
            return;
        }
        if (node.getSize() == n || n < 0) {
            this.blist.add(node);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.NodeOfSize(node.getChildAt(i), n);
        }
        node.setMark(1);
    }

    public List getLeafs() {
        this.markTree(0);
        this.blist.clear();
        this.leafs(this.getRoot());
        return this.blist;
    }

    void leafs(Node node) {
        if (node.getMark() != 0) {
            return;
        }
        if (node.getChildCount() == 0) {
            this.blist.add(node);
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.leafs(node.getChildAt(i));
        }
        node.setMark(1);
    }

    public Tree getClone() {
        DefaultTree defaultTree = new DefaultTree();
        defaultTree.setRoot(this.cloneNode());
        return defaultTree;
    }

    public Node cloneNode() {
        try {
            Node node = this.getRoot().getClone();
            this.cloneMore(node, this.getRoot());
            return node;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void cloneMore(Node node, Node node2) {
        for (int i = 0; i < node2.getChildCount(); ++i) {
            Node node3 = node2.getChildAt(i);
            Node node4 = node3.getClone();
            node.addChild(node4);
            this.cloneMore(node4, node3);
        }
    }

    public int leafSize() {
        this.needUpdateSize = true;
        if (this.needUpdateSize) {
            if (this.allNodes != null) {
                this.sampleSize = 0;
                for (int i = this.allNodes.length - 1; i >= 0; --i) {
                    if (this.allNodes[i] == null || this.allNodes[i].getParentCount() <= 0 || this.allNodes[i].getChildCount() != 0) continue;
                    ++this.sampleSize;
                }
            } else {
                this.sampleSize = 0;
                this.nodeSize = 0;
                this.markTree(0);
                this.countTips(this.getRoot());
            }
            this.needUpdateSize = false;
        }
        return this.sampleSize;
    }

    void countTips(Node node) {
        if (node.getMark() != 0) {
            return;
        }
        ++this.nodeSize;
        if (node.getChildCount() == 0) {
            ++this.sampleSize;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.countTips(node.getChildAt(i));
        }
        node.setMark(1);
    }

    public int size() {
        if (this.needUpdateSize) {
            this.sampleSize = 0;
            this.nodeSize = 0;
            this.markTree(0);
            this.countTips(this.getRoot());
            this.needUpdateSize = false;
        }
        return this.nodeSize;
    }

    public double height() {
        return 0.0;
    }
}

