/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class DefaultNode
implements Node,
Cloneable,
Serializable {
    private Node[] child = new Node[2];
    private Node[] parent = new Node[1];
    private Object userObject;
    private int nextChild = 0;
    private int nextParent = 0;
    private String name;
    private Branch[] branch = new Branch[1];
    private int size;
    private int[] sizes;
    private Object content;
    private int eventNumber;
    private static int nextID;
    private final int ID;
    private int mark = 0;
    protected int nameID;
    private double time;

    public DefaultNode() {
        this.branch[0] = new DefaultBranch();
        this.ID = nextID++;
        this.nameID = -1;
        this.time = 0.0;
    }

    public Node getClone() {
        DefaultNode defaultNode = new DefaultNode();
        defaultNode.getBranch().setLength(this.getBranch().getLength());
        defaultNode.getBranch().setMutation(this.getBranch().getMutation());
        defaultNode.getBranch().setName(this.getBranch().getName());
        defaultNode.getBranch().setSize(this.getBranch().getSize());
        defaultNode.getBranch().setWeight(this.getBranch().getWeight());
        defaultNode.getBranch().setUserObject(this.getBranch().getUserObject());
        defaultNode.setContent(this.getContent());
        defaultNode.setEventNumber(this.getEventNumber());
        defaultNode.setMark(this.getMark());
        defaultNode.setName(this.getName());
        defaultNode.setNameID(this.getNameID());
        defaultNode.setSize(this.getSize());
        defaultNode.setSizes(this.getSizes());
        defaultNode.setTime(this.getTime());
        defaultNode.setUserObject(this.getUserObject());
        return defaultNode;
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public DefaultNode(String string) {
        this();
        this.setName(string);
    }

    public void addChild(Node node) {
        if (this.nextChild == this.child.length) {
            this.child = DefaultNode.growNodeArray(this.child);
        }
        this.child[this.nextChild++] = node;
        node.addParent(this);
    }

    public boolean setChildAt(int n, Node node) {
        if (n == this.nextChild) {
            this.addChild(node);
            return true;
        }
        if (DefaultNode.indexOf(this.child, node) >= 0) {
            return false;
        }
        Node node2 = this.child[n];
        this.child[n] = node;
        node2.removeParent(this);
        node.addParent(this);
        return true;
    }

    public int getChildCount() {
        return this.nextChild;
    }

    public boolean removeChild(Node node) {
        if (DefaultNode.remove(this.child, node)) {
            --this.nextChild;
            node.removeParent(this);
            return true;
        }
        return false;
    }

    public Node removeChild(int n) {
        int n2 = this.getChildCount();
        if (n < 0 || n >= n2) {
            return null;
        }
        Node node = this.child[n];
        for (int i = n; i < n2 - 1; ++i) {
            this.child[i] = this.child[i + 1];
        }
        this.child[n2 - 1] = null;
        --this.nextChild;
        node.removeParent(this);
        return node;
    }

    public void removeAllChild() {
        for (int i = this.nextChild - 1; i >= 0; --i) {
            if (this.child[i] == null) continue;
            this.child[i].removeParent(this);
            this.child[i] = null;
        }
        this.nextChild = 0;
    }

    public int indexOfChild(Node node) {
        return DefaultNode.indexOf(this.child, node);
    }

    public Node getChildAt(int n) {
        return this.child[n];
    }

    public int getParentCount() {
        return this.nextParent;
    }

    public int indexOfParent(Node node) {
        return DefaultNode.indexOf(this.parent, node);
    }

    public void removeAllParent() {
        for (int i = this.nextParent - 1; i >= 0; --i) {
            Node node = this.parent[i];
            this.parent[i] = null;
            --this.nextParent;
            node.removeChild(this);
        }
    }

    public void addParent(Node node) {
        if (this.nextParent == this.parent.length) {
            this.parent = DefaultNode.growNodeArray(this.parent);
            Branch[] branchArray = this.branch;
            this.branch = new DefaultBranch[this.parent.length];
            System.arraycopy(branchArray, 0, this.branch, 0, branchArray.length);
            this.branch[this.parent.length - 1] = new DefaultBranch();
        }
        this.parent[this.nextParent++] = node;
    }

    public void setParent(Node node) {
        this.setParentAt(0, node);
    }

    public Node getParent() {
        return this.parent[0];
    }

    public boolean setParentAt(int n, Node node) {
        if (n < this.nextParent) {
            if (DefaultNode.indexOf(this.parent, node) >= 0) {
                return false;
            }
            Node node2 = this.parent[n];
            node2.removeChild(this);
            this.parent[n] = node;
        } else {
            this.addParent(node);
        }
        return true;
    }

    public boolean removeParent(Node node) {
        if (DefaultNode.remove(this.parent, node)) {
            --this.nextParent;
            return node.removeChild(this);
        }
        return false;
    }

    public Node removeParent(int n) {
        if (n < 0 || n >= this.getParentCount()) {
            return null;
        }
        Node node = DefaultNode.remove(this.parent, n);
        if (node != null) {
            --this.nextParent;
            node.removeChild(this);
        }
        return node;
    }

    public Node getParentAt(int n) {
        return this.parent[n];
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "DefaultNode";
    }

    public void clear() {
        this.removeAllChild();
        this.removeAllParent();
        this.setName(null);
        this.setUserObject(null);
        this.setMark(0);
        this.setEventNumber(0);
    }

    public void fastClear() {
        int n = this.getChildCount();
        while (n-- > 0) {
            this.child[n] = null;
        }
        n = this.getParentCount();
        while (n-- > 0) {
            this.parent[n] = null;
        }
        this.nextChild = 0;
        this.nextParent = 0;
        this.setEventNumber(0);
        this.setName(null);
        this.setSize(0);
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setContent(Object object) {
        this.content = object;
    }

    public Object getContent() {
        return this.content;
    }

    public void setEventNumber(int n) {
        this.eventNumber = n;
    }

    public int getEventNumber() {
        return this.eventNumber;
    }

    public int getID() {
        return this.ID;
    }

    public void setMark(int n) {
        this.mark = n;
    }

    public int getMark() {
        return this.mark;
    }

    public boolean isAncestorOf(Node node) {
        if (node == null) {
            return false;
        }
        if (node == this) {
            return true;
        }
        while (node.getParentCount() > 0) {
            if (node.getParentAt(0) == this) {
                return true;
            }
            node = node.getParentAt(0);
        }
        return false;
    }

    public Branch getBranch(int n) {
        return this.branch[n];
    }

    public Branch getBranch() {
        return this.branch[0];
    }

    public int getSize() {
        return this.size;
    }

    public int[] getSizes() {
        return this.sizes;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setSizes(int[] nArray) {
        this.sizes = nArray;
    }

    public static Node[] growNodeArray(Node[] nodeArray) {
        Node[] nodeArray2 = nodeArray;
        nodeArray = new Node[nodeArray.length + 1];
        System.arraycopy(nodeArray2, 0, nodeArray, 0, nodeArray2.length);
        return nodeArray;
    }

    public static boolean remove(Node[] nodeArray, Node node) {
        if (node == null) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] != node) continue;
            for (int j = i; j < nodeArray.length - 1; ++j) {
                nodeArray[j] = nodeArray[j + 1];
            }
            nodeArray[nodeArray.length - 1] = null;
            return true;
        }
        return false;
    }

    public static Node remove(Node[] nodeArray, int n) {
        if (n < 0 || n >= nodeArray.length || nodeArray[n] == null) {
            return null;
        }
        Node node = nodeArray[n];
        for (int i = n; i < nodeArray.length - 1; ++i) {
            nodeArray[i] = nodeArray[i + 1];
        }
        nodeArray[nodeArray.length - 1] = null;
        return node;
    }

    public static int indexOf(Node[] nodeArray, Node node) {
        int n = nodeArray.length;
        while (n-- > 0) {
            if (nodeArray[n] != node) continue;
            return n;
        }
        return -1;
    }

    public int getNameID() {
        return this.nameID;
    }

    public void setNameID(int n) {
        this.nameID = n;
    }
}

