/*
 * Decompiled with CFR 0.152.
 */
import cern.jet.random.Poisson;
import cern.jet.random.engine.MersenneTwister64;

public class DefaultGenealogy
extends DefaultTree
implements Genealogy {
    protected int nLoci = 1;
    protected int[] freq = intZero;
    protected int[] mutLoci = intZero;
    protected double[] branch = doubleZero;
    protected boolean needUpdateMutation = true;
    protected boolean needUpdateAllele = true;
    protected boolean needUpdateBranch = true;
    protected boolean needUpdateTips = true;
    protected double ageofMRCA = 0.0;
    protected CoalescentTime lastCoalTime;
    private boolean debug = false;
    protected Poisson poisson = RandomUtil.getPoisson();
    protected MersenneTwister64 random = RandomUtil.getMersenneTwister64();

    public void setRnGenerator(MersenneTwister64 mersenneTwister64) {
        if (mersenneTwister64 != null) {
            this.random = mersenneTwister64;
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setRoot(Node node) {
        this.updateGenealogy();
        super.setRoot(node);
        Object object = this.getRoot().getContent();
        if (object != null && object instanceof Chromosome) {
            this.nLoci = ((Chromosome)object).getLength();
        }
    }

    public int getLociCount() {
        return this.nLoci;
    }

    public double height() {
        return this.ageofMRCA;
    }

    private void setHeight(double d) {
        this.ageofMRCA = d;
    }

    public void updateGenealogy() {
        this.needUpdateTips = true;
        this.needUpdateMutation = true;
        this.needUpdateAllele = true;
        this.needUpdateBranch = true;
    }

    public Tree getClone() {
        DefaultGenealogy defaultGenealogy = new DefaultGenealogy();
        return defaultGenealogy;
    }

    public void setBranchLength(CoalescentTime coalescentTime) {
        int n;
        if (coalescentTime != null) {
            if (this.getRoot().getEventNumber() < coalescentTime.number()) {
                throw new Error("illigal coalescent time, not have enough events");
            }
            this.lastCoalTime = coalescentTime;
            this.ageofMRCA = coalescentTime.event(this.getRoot().getEventNumber());
        }
        if ((n = this.leafSize()) == 0) {
            System.out.println(this.allNodes.length + " leafSize=" + n);
        }
        if (this.branch.length < n + 1) {
            this.branch = new double[n + 1];
        }
        for (int i = this.branch.length - 1; i >= 0; --i) {
            this.branch[i] = 0.0;
        }
        if (this.allNodes != null) {
            this.setTime(this.allNodes, coalescentTime);
        } else {
            this.markTree(0);
            this.setTime(this.getRoot(), coalescentTime);
        }
        this.needUpdateBranch = false;
    }

    protected void setTime(Node[] nodeArray, CoalescentTime coalescentTime) {
        for (int i = nodeArray.length - 1; i >= 0; --i) {
            Node node = nodeArray[i];
            if (node == null) continue;
            this.setTimeFor(node, coalescentTime);
        }
    }

    protected void setTime(Node node, CoalescentTime coalescentTime) {
        if (node.getMark() != 0) {
            return;
        }
        this.setTimeFor(node, coalescentTime);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.setTime(node.getChildAt(i), coalescentTime);
        }
        node.setMark(1);
    }

    protected void setTimeFor(Node node, CoalescentTime coalescentTime) {
        if (coalescentTime == null) {
            return;
        }
        double d = coalescentTime.event(node.getEventNumber());
        for (int i = node.getParentCount() - 1; i >= 0; --i) {
            Branch branch = node.getBranch(i);
            int n = node.getParentAt(i).getEventNumber();
            branch.setLength(coalescentTime.event(n) - d);
            if (this.nLoci > 1) {
                Chromosome chromosome = node.getParentCount() > 1 ? (Chromosome)node.getParentAt(i).getContent() : (Chromosome)node.getContent();
                double d2 = branch.getLength() / (double)chromosome.getLength();
                for (int j = this.nLoci - 1; j >= 0; --j) {
                    int n2 = chromosome.getSize(j);
                    if (n2 <= 0) continue;
                    int n3 = n2;
                    this.branch[n3] = this.branch[n3] + d2;
                }
            } else {
                int n4 = node.getSize();
                this.branch[n4] = this.branch[n4] + branch.getLength();
            }
            this.branch[0] = this.branch[0] + branch.getLength() * branch.getWeight();
        }
    }

    public void mutate(double d) {
        this.makeMutation(d, true);
    }

    protected void makeMutation(double d, boolean bl) {
        int n;
        if (this.mutLoci.length < this.nLoci) {
            this.mutLoci = new int[this.nLoci];
        }
        for (n = 0; n < this.nLoci; ++n) {
            this.mutLoci[n] = 0;
        }
        if (this.freq.length < this.leafSize() + 1) {
            this.freq = new int[this.leafSize() + 1];
        }
        for (n = this.freq.length - 1; n >= 0; --n) {
            this.freq[n] = 0;
        }
        if (this.allNodes != null) {
            for (n = this.allNodes.length - 1; n >= 0; --n) {
                if (this.allNodes[n] == null) continue;
                this.mutationFor(this.allNodes[n], d, bl);
            }
        } else {
            this.markTree(0);
            this.mutation(this.getRoot(), d, bl);
        }
        this.needUpdateMutation = false;
        if (this.nLoci == 1) {
            this.mutLoci[0] = this.freq[0];
        }
    }

    protected void mutation(Node node, double d, boolean bl) {
        if (node.getMark() != 0) {
            return;
        }
        this.mutationFor(node, d, bl);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.mutation(node.getChildAt(i), d, bl);
        }
        node.setMark(1);
    }

    protected void mutationFor(Node node, double d, boolean bl) {
        for (int i = node.getParentCount() - 1; i >= 0; --i) {
            Branch branch = node.getBranch(i);
            if (bl) {
                branch.setMutation(this.poisson.nextInt(0.5 * branch.getLength() * branch.getWeight() * d));
            }
            if (branch.getMutation() <= 0) continue;
            int n = this.getLociCount();
            if (n > 1) {
                int n2;
                int n3;
                Object object = branch.getUserObject();
                Chromosome chromosome = node.getParentCount() > 1 ? (Chromosome)node.getParentAt(i).getContent() : (Chromosome)node.getContent();
                if (object == null || ((int[])object).length != n) {
                    branch.setUserObject(new int[n]);
                }
                int[] nArray = (int[])branch.getUserObject();
                if (bl) {
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray[n3] = 0;
                    }
                    n3 = chromosome.cardinality();
                    for (n2 = branch.getMutation(); n2 > 0; --n2) {
                        int n4;
                        int n5 = (int)(this.random.nextDouble() * (double)n3);
                        int n6 = n4 = chromosome.getActiveLoci(n5 + 1);
                        nArray[n6] = nArray[n6] + 1;
                        int n7 = n4;
                        this.mutLoci[n7] = this.mutLoci[n7] + 1;
                    }
                }
                for (n3 = n - 1; n3 >= 0; --n3) {
                    n2 = chromosome.getSize(n3);
                    if (n2 > 0) {
                        int n8 = n2;
                        this.freq[n8] = this.freq[n8] + nArray[n3];
                    }
                    if (nArray[n3] <= 0) continue;
                }
            } else {
                int n9 = node.getSize();
                this.freq[n9] = this.freq[n9] + branch.getMutation();
            }
            this.freq[0] = this.freq[0] + branch.getMutation();
        }
    }

    public Genealogy getGenealogy(int n) {
        return null;
    }

    protected void retain(Node node, int n) {
        Chromosome chromosome = (Chromosome)node.getContent();
        if (chromosome.getSize(n) == 0) {
            this.removeDescendents(node);
            return;
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            this.retain(node.getChildAt(i), n);
        }
    }

    protected void removeDescendents(Node node) {
        node.removeAllParent();
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            Node node2 = node.getChildAt(i);
            if (node2.getParentCount() == 1) {
                this.removeDescendents(node2);
                continue;
            }
            node.removeChild(i);
        }
    }

    public Sequence[] getSequences() {
        return null;
    }
}

